/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils.jsse;

import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.ws.utils.jsse.FnJSSESocketFactory;
import filenet.ws.utils.jsse.WSJSSE;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class FnTrustManager
implements X509TrustManager {
    private KeyStore keyStore;
    private String keyStorePath;
    private char[] keyStorePassword;
    private X509TrustManager standardTrustManager = null;
    protected static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator.WebServices.SSL");
    private static String m_className = "FnTrustManager";
    boolean autoTrusted = false;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:04:38  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.4  $";
    }

    public FnTrustManager(KeyStore keyStore, String keyStorePath, char[] keyStorePassword, boolean autoTrusted) throws Exception {
        this.keyStore = keyStore;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.autoTrusted = autoTrusted;
        WSJSSE wsjsse = WSJSSE.getInstance();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(wsjsse.getTrustManagerAlgorithm());
        tmf.init(keyStore);
        TrustManager[] tms = tmf.getTrustManagers();
        for (int i = 0; i < tms.length; ++i) {
            if (!(tms[i] instanceof X509TrustManager)) continue;
            this.standardTrustManager = (X509TrustManager)tms[i];
            return;
        }
        throw new Exception("Couldn't initialize");
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.standardTrustManager.checkClientTrusted(chain, authType);
        }
        catch (CertificateException cerEx) {
            if (!this.autoTrusted) {
                throw cerEx;
            }
            this.handleUntrustedCertificate(chain, authType);
        }
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.standardTrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException cerEx) {
            if (!this.autoTrusted) {
                throw cerEx;
            }
            this.handleUntrustedCertificate(chain, authType);
        }
    }

    private void traceCertificates(X509Certificate[] chain, String authType) {
        if (logger.isLoggable(Level.FINEST)) {
            String m_method = "traceCertificates";
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < chain.length; ++i) {
                buf.append("\nauthType=").append(authType).append("\nCertificate chain[" + i + "]:").append(chain[i]);
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, buf.toString());
            }
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }

    private void refreshKeyStore() {
        try {
            this.keyStore = FnJSSESocketFactory.initKeyStore(this.keyStorePath, this.keyStorePassword);
        }
        catch (Throwable t) {
            logger.finest(m_className, "refreshKeyStore", "Ex:" + t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUntrustedCertificate(X509Certificate[] chain, String authType) {
        String m_method = "handleUntrustedCertificate:" + authType;
        logger.entering(m_className, m_method);
        this.traceCertificates(chain, authType);
        try {
            this.refreshKeyStore();
            logger.finest(m_className, m_method, "Trusting certificates...");
            for (int i = 0; i < chain.length; ++i) {
                this.keyStore.setCertificateEntry(((Object)chain[i].getIssuerDN()).toString(), chain[i]);
            }
            FileOutputStream keyStoreOStream = null;
            try {
                keyStoreOStream = new FileOutputStream(this.keyStorePath);
                this.keyStore.store(keyStoreOStream, this.keyStorePassword);
                keyStoreOStream.close();
                keyStoreOStream = null;
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Saved certificates to " + this.keyStorePath);
                }
            }
            catch (Throwable t) {
                logger.warning(m_className, m_method, "Failed to store certificates to " + this.keyStorePath + ", ex=" + t.getMessage());
            }
            finally {
                if (keyStoreOStream != null) {
                    try {
                        keyStoreOStream.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
        }
        logger.exiting(m_className, m_method);
    }
}

